# SuiteSparse Matrix Collection

Note: All graphs in SuitSparse belong to groups which will have more information about the graphs and the sub-collections they belong to. In our Descriptions from the Literature section we also highlight a few tables with the specific graphs used in a couple of papers. 
Origin Notes: From “The university of Florida Sparse Matrix Collection”, Davis and Hu describe the origin of this network repository. Namely they cite the Harwell-Boeing collection as the starting point for SuiteSparse, then called the University of Florida (UF) Sparse matrix collection, back in 1991. Other groups, or collections, have then been added to SuitseSparse through the years, mainly focusing on real-world matrices and other relevant problems related to them. 
graph features handled: Bipartite, Categorical nodes, Dense, Directed edges, Dynamic, Generic, Hierarchical, Large, Mesh, Multigraph, Sparse, Spatial, Weighted edges, Weighted nodes, temporal
Graph features in papers: generic,large,weighted edges,generic,large,multilevel,clusters (generated),generic,planar,spatial,almost proximity drawable graphs,mesh graphs,scale-free graphs,strong proximity drawable graphs,weak proximity drawable graphs
Origin Paper: The University of Florida Sparse Matrix Collection (https://www.notion.so/The-University-of-Florida-Sparse-Matrix-Collection-b861824a77d94175af99b7b367768cb3?pvs=21)
Originally found at: https://sparse.tamu.edu/
Size: 2893
Child collections: Walshaw (Walshaw%20e40b37a1147942d89ff1d8dfad285256.md), Pajek (Pajek%20e323e05a735d4151a0bccfec08aa3bd6.md)
Appeared in years: 2013,2016,2017,2019,2020,2021,2023
Type of Collection: Established Network Repo (No report)
is it stored properly?: No
must be analyzed: Yes
In repo?: No
Related to Literature - Algorithm (1) (Dataset tag relations): Graph Layouts by t-SNE (https://www.notion.so/Graph-Layouts-by-t-SNE-6adb46473eb2415294b0d797ad86b077?pvs=21), Drawing Big Graphs Using Spectral
Sparsification (https://www.notion.so/Drawing-Big-Graphs-Using-Spectral-Sparsification-89da2043d0444f75a6c663b1fc999512?pvs=21), A Maxent-Stress Model for Graph Layout (https://www.notion.so/A-Maxent-Stress-Model-for-Graph-Layout-8da4fc24a7c7438c9d10c3113841b7fd?pvs=21), Multi-level Graph Drawing Using Infomap Clustering (https://www.notion.so/Multi-level-Graph-Drawing-Using-Infomap-Clustering-ad97d205cc804c748ab87d3012b18ebc?pvs=21), A Sparse Stress Model (https://www.notion.so/A-Sparse-Stress-Model-ba603193aa4c49a8a55e1d23068def6f?pvs=21), Stochastic Gradient Descent Works Really Well for Stress Minimization (https://www.notion.so/Stochastic-Gradient-Descent-Works-Really-Well-for-Stress-Minimization-e1cb81e542004fdf848c5a303e9e43e5?pvs=21)
cleaned format?: No
duplicate?: No
link works?: No
Added in paper: No
Origin paper plaintext: The University of Florida Sparse Matrix Collection
Page id: b8772d6a2cbb456894b4673e32c6f956
unavailable/skip: Yes
Cleaned ALL data: No
first look: No
Related to Literature - Algorithm (Dataset tag relations) 1: A Maxent-Stress Model for Graph Layout (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/A%20Maxent-Stress%20Model%20for%20Graph%20Layout%2000c097ef77dd46d6a2df74869581a5c9.md), A Sparse Stress Model (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/A%20Sparse%20Stress%20Model%2096e7e209fadc468f9156cb44d0c8e59b.md), Drawing Big Graphs Using Spectral
Sparsification (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Drawing%20Big%20Graphs%20Using%20Spectral%20Sparsification%20e5d3efdca48541f2b1789ec74357ebf6.md), Multi-level Graph Drawing Using Infomap Clustering (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Multi-level%20Graph%20Drawing%20Using%20Infomap%20Clustering%20eadf3605c6ed46ff93629fb92858fbd4.md), Stochastic Gradient Descent Works Really Well for Stress Minimization (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Stochastic%20Gradient%20Descent%20Works%20Really%20Well%20for%20%20af084ad735564f1da5f20c16773572d0.md), Graph Layouts by t-SNE (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Graph%20Layouts%20by%20t-SNE%203af4ccbc89b547a38748745511744997.md), Graph Drawing by Stochastic Gradient Descent (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Graph%20Drawing%20by%20Stochastic%20Gradient%20Descent%20c829549f150044628d68b79584273c19.md), DRGraph: An Efficient Graph Layout Algorithm for Large-scale Graphs by Dimensionality Reduction (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/DRGraph%20An%20Efficient%20Graph%20Layout%20Algorithm%20for%20La%203e38c2bb01724b70be45cb8d19695051.md), Force-Directed Graph Layouts Revisited: A New Force Based on the T-Distribution (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Force-Directed%20Graph%20Layouts%20Revisited%20A%20New%20Force%208c79f21b6f2a41fca20311b3ba1ab644.md), Spherical Graph Drawing by Multi-dimensional Scaling (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Spherical%20Graph%20Drawing%20by%20Multi-dimensional%20Scali%20f12cabb0ee2d48d398492f62af07404b.md), Shape-Faithful Graph Drawings (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Shape-Faithful%20Graph%20Drawings%209551555e517f400ea733e3e3c56c8686.md)

# Body

### Descriptions From Literature

From “[A Sparse Stress Model](https://dx.doi.org/10.7155/jgaa.00440)”:

> We conducted our experiments on a series of different graphs, see Tab. 1, most of them taken from the sparse matrix collection [9]. We selected these graphs as they differ in their structure and size, and are large enough to compare the results of different techniques. Two of the graphs, LeHavre and commanche, have predefined edge lengths that were derived from the node coordinates. We did not modify the graphs in any way, except for those that were disconnected, in which case we only kept the largest component.
> 

![Untitled](SuiteSparse%20Matrix%20Collection%20b8772d6a2cbb456894b4673e32c6f956/Untitled.png)

From “[A Maxent-Stress Model for Graph Layout](https://doi.org/10.1109/TVCG.2012.299)”:

> With the exception of graph gd, which is an author collaboration graph of the International Symposium on Graph Drawing between 1994 and 2007, the graphs used are from the University of Florida Sparse Matrix Collection [9]. Our selection covers a range of graph sizes, and includes mesh-like and other nonmesh graphs, and graphs from Brandes and Pich's experimental study of distance scaling [5].
> 

![Untitled](SuiteSparse%20Matrix%20Collection%20b8772d6a2cbb456894b4673e32c6f956/Untitled%201.png)

**Table 2.** Test Graphs

From “[DRGraph: An Efficient Graph Layout Algorithm for Large-scale Graphs by Dimensionality Reduction](https://doi.org/10.1109/TVCG.2020.3030447)”:

> We perform experiments on a broad range of datasets selected from the University of Florida Sparse Matrix Collection [10] and tsNET [34] (Table 1).
> 

![Untitled](SuiteSparse%20Matrix%20Collection%20b8772d6a2cbb456894b4673e32c6f956/Untitled%202.png)

**Table 1.** Test Datasets

### Example Figures

From “[The university of Florida sparse matrix collection](https://doi.org/10.1145/2049662.2049663)**”:**

![Untitled](SuiteSparse%20Matrix%20Collection%20b8772d6a2cbb456894b4673e32c6f956/Untitled%203.png)

**Fig. 13.** A sample of matrices from the Collection, for the purpose of illustrating the complexity and diversity of matrices arising in real applications

From “[DRGraph: An Efficient Graph Layout Algorithm for Large-scale Graphs by Dimensionality Reduction](https://doi.org/10.1109/TVCG.2020.3030447)”:

![Untitled](SuiteSparse%20Matrix%20Collection%20b8772d6a2cbb456894b4673e32c6f956/Untitled%204.png)

**Fig. 8.** Visualizations of selected graph datasets using FR, KK, S.M., FM3, SFDP, PMDS, tsNET and DRGraph.

=== STOP RENDERING ===

it was originally named “University of Florida Sparse Matrix collection”

[Children of SuiteSparse Matrix collection](SuiteSparse%20Matrix%20Collection%20b8772d6a2cbb456894b4673e32c6f956/Children%20of%20SuiteSparse%20Matrix%20collection%20d16b1e4a85034b53935fd3c1285860cc.csv)

Davis, T.A., Hu, Y.: The University of Florida sparse matrix collection. ACM

Trans. Math. Softw. 38(1), 1 (2011). https://doi.org/10.1145/2049662.2049663